#!/bin/bash

echo "🔧 Disabling screen lock and screen blanking..."

# GNOME Settings
if command -v gsettings &> /dev/null; then
    echo "📺 Applying GNOME screen settings..."
    export DISPLAY=:0
    export XDG_RUNTIME_DIR="/run/user/$(id -u)"
    gsettings set org.gnome.desktop.session idle-delay 0
    gsettings set org.gnome.desktop.screensaver lock-enabled false
    gsettings set org.gnome.desktop.screensaver idle-activation-enabled false
    gsettings set org.gnome.settings-daemon.plugins.power idle-dim false
    gsettings set org.gnome.settings-daemon.plugins.power sleep-inactive-ac-type 'nothing'
    gsettings set org.gnome.settings-daemon.plugins.power sleep-inactive-battery-type 'nothing'
    echo "✅ GNOME settings applied."
fi

# X11 screen blanking
if [ -n "$DISPLAY" ] && command -v xset &> /dev/null; then
    echo "📺 Disabling X11 screen blanking..."
    xset s off        # Turn off screen saver
    xset -dpms        # Disable DPMS (Energy Star)
    xset s noblank    # Disable screen blanking
    echo "✅ X11 screen saver and blanking disabled."
fi

# Set power mode to performance
if command -v powerprofilesctl &> /dev/null; then
    powerprofilesctl set performance
    echo "⚡ Power profile set to performance."
fi

echo "🎉 Done! Screen will stay on and not lock."


####################################################
# 🛠️ Install for all users via autostart
####################################################

echo "🔧 Installing autostart for all users..."

TARGET_DIR="/opt/disable-screen-lock"
SCRIPT_PATH="$TARGET_DIR/disable.sh"

# Copy this script to the target directory
sudo mkdir -p "$TARGET_DIR"
sudo cp "$0" "$SCRIPT_PATH"
sudo chmod 755 "$SCRIPT_PATH"

# Create a .desktop file for autostart
DESKTOP_ENTRY="/etc/xdg/autostart/disable-screen-lock.desktop"

sudo tee "$DESKTOP_ENTRY" > /dev/null <<EOF
[Desktop Entry]
Type=Application
Exec=$SCRIPT_PATH
Hidden=false
NoDisplay=false
X-GNOME-Autostart-enabled=true
Name=Disable Screen Lock
Comment=Disables screen lock and screen blanking for all users
OnlyShowIn=GNOME;Unity;X-Cinnamon;MATE;
EOF

echo "✅ Autostart entry created at $DESKTOP_ENTRY"
echo "🌀 Settings will apply for every user at GUI login."

