#!/bin/bash

# Function to install AnyDesk
install_rustdesk() {
    if command -v rustdesk > /dev/null 2>&1; then
        echo "✅ RustDesk is already installed. Skipping installation."
    else
        echo "📥 Installing RustDesk..."
        sudo apt install -y ./rustdesk.deb
        echo "✅ RustDesk installation complete."
    fi
}


disable_wayland() {
    echo "🛑 Disabling Wayland... for RUSTDESK LOGIN SCREEN ACCESS"

    # Modify the GDM configuration to disable Wayland
    sudo sed -i 's/^#WaylandEnable=false/WaylandEnable=false/' /etc/gdm3/custom.conf

    echo "✅ Wayland is now disabled. System is using Xorg."
}


# Function to install Google Chrome
install_chrome() {
    if command -v google-chrome > /dev/null 2>&1; then
        echo "Google Chrome is already installed. Skipping Google Chrome installation."
    else
        echo "Installing Google Chrome..."
        # Download the latest stable version of Google Chrome
        wget -q https://dl.google.com/linux/direct/google-chrome-stable_current_amd64.deb
        # Install the package
        sudo dpkg -i google-chrome-stable_current_amd64.deb
        sudo apt-get install -f -y  # Fix dependencies if any
        echo "Google Chrome installation complete."
    fi
}

# Function to install VLC
install_vlc() {
    if command -v vlc > /dev/null 2>&1; then
        echo "VLC is already installed. Skipping VLC installation."
    else
        echo "Installing VLC..."
        sudo apt update
        sudo apt install -y vlc
        echo "VLC installation complete."
    fi
}

# Check if the script is running as root
if [ "$(id -u)" -ne 0 ]; then
    echo "This script must be run as root (use sudo)."
    exit 1
fi

# Install AnyDesk, Google Chrome, and VLC
install_chrome
install_vlc
install_rustdesk
disable_wayland

echo "Installation of CHROME, RustDESK, and VLC script complete."
